<?php

require_once dirname( __FILE__ ) . '/font.php';

/**
 * Akar Icons
 *
 * @package Icon_Picker
 * @author  Dzikri Aziz <kvcrvt@gmail.com>
 */
class Icon_Picker_Type_Akar_Icons extends Icon_Picker_Type_Font {

	/**
	 * Icon type ID
	 *
	 * @since  0.1.0
	 * @access protected
	 * @var    string
	 */
	protected $id = 'akar-icons';

	/**
	 * Icon type name
	 *
	 * @since  0.1.0
	 * @access protected
	 * @var    string
	 */
	protected $name = 'Akar';

	/**
	 * Icon type version
	 *
	 * @since  0.1.0
	 * @access protected
	 * @var    string
	 */
	protected $version = '1.1.19';


	/**
	 * Get icon groups
	 *
	 * @since  0.1.0
	 * @return array
	 */
	public function get_groups() {
		$groups = array(
			array(
				'id'   => 'arrows',
				'name' => __( 'Arrows', 'logistics-hub' ),
			),
			array(
				'id'   => 'ecommerce',
				'name' => __( 'Ecommerce', 'logistics-hub' ),
			),
			array(
				'id'   => 'general',
				'name' => __( 'General', 'logistics-hub' ),
			),
			array(
				'id'   => 'people',
				'name' => __( 'People', 'logistics-hub' ),
			),
			array(
				'id'   => 'social',
				'name' => __( 'Social/Brand', 'logistics-hub' ),
			),
		);
		/**
		 * Filter genericon groups
		 *
		 * @since 0.1.0
		 * @param array $groups Icon groups.
		 */
		$groups = apply_filters( 'icon_picker_foundations_groups', $groups );

		return $groups;
	}


	/**
	 * Get icon names
	 *
	 * @since  0.1.0
	 * @return array
	 */
	public function get_items() {
		$items = array(
			array(
				'group' => 'arrows',
				'id'    => 'ai-arrow-left',
				'name'  => __( 'Arrow Left', 'logistics-hub' ),
			),
			array(
				'group' => 'arrows',
				'id'    => 'ai-arrow-right',
				'name'  => __( 'Arrow Right', 'logistics-hub' ),
			),
			array(
				'group' => 'arrows',
				'id'    => 'ai-arrow-up',
				'name'  => __( 'Arrow Up', 'logistics-hub' ),
			),
			array(
				'group' => 'arrows',
				'id'    => 'ai-arrow-down',
				'name'  => __( 'Arrow Down', 'logistics-hub' ),
			),
			array(
				'group' => 'arrows',
				'id'    => 'ai-arrow-down-left',
				'name'  => __( 'Arrow Down Left', 'logistics-hub' ),
			),
			array(
				'group' => 'arrows',
				'id'    => 'ai-arrow-up-left',
				'name'  => __( 'Arrow Up Left', 'logistics-hub' ),
			),
			array(
				'group' => 'arrows',
				'id'    => 'ai-arrow-up-right',
				'name'  => __( 'Arrow Up Right', 'logistics-hub' ),
			),
			array(
				'group' => 'arrows',
				'id'    => 'ai-arrow-down-right',
				'name'  => __( 'Arrow Down Right', 'logistics-hub' ),
			),
			array(
				'group' => 'arrows',
				'id'    => 'ai-chevron-left',
				'name'  => __( 'Chevron Left', 'logistics-hub' ),
			),
			array(
				'group' => 'arrows',
				'id'    => 'ai-chevron-right-small',
				'name'  => __( 'Chevron Right Small', 'logistics-hub' ),
			),
			array(
				'group' => 'arrows',
				'id'    => 'ai-chevron-right',
				'name'  => __( 'Chevron Right', 'logistics-hub' ),
			),
			array(
				'group' => 'arrows',
				'id'    => 'ai-chevron-up',
				'name'  => __( 'Chevron Up', 'logistics-hub' ),
			),
			array(
				'group' => 'arrows',
				'id'    => 'ai-chevron-down-small',
				'name'  => __( 'Chevron Down Small', 'logistics-hub' ),
			),
			array(
				'group' => 'arrows',
				'id'    => 'ai-chevron-down',
				'name'  => __( 'Chevron Down', 'logistics-hub' ),
			),
			array(
				'group' => 'arrows',
				'id'    => 'ai-arrow-cycle',
				'name'  => __( 'Arrow Cycle', 'logistics-hub' ),
			),
			array(
				'group' => 'arrows',
				'id'    => 'ai-arrow-clockwise',
				'name'  => __( 'Arrow Clockwise', 'logistics-hub' ),
			),
			array(
				'group' => 'arrows',
				'id'    => 'ai-arrow-counter-clockwise',
				'name'  => __( 'Arrow Counter Clockwise', 'logistics-hub' ),
			),
			array(
				'group' => 'arrows',
				'id'    => 'ai-arrow-back-thick',
				'name'  => __( 'Arrow Back Thick', 'logistics-hub' ),
			),
			array(
				'group' => 'arrows',
				'id'    => 'ai-arrow-back-thick-fill',
				'name'  => __( 'Arrow Back Thick Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'arrows',
				'id'    => 'ai-arrow-forward-thick',
				'name'  => __( 'Arrow Forward Thick', 'logistics-hub' ),
			),
			array(
				'group' => 'arrows',
				'id'    => 'ai-arrow-forward-thick-fill',
				'name'  => __( 'Arrow Forward Thick Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-width',
				'name'  => __( 'Width', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-height',
				'name'  => __( 'Height', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-enlarge',
				'name'  => __( 'Enlarge', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-reduce',
				'name'  => __( 'Reduce', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-arrow-left-thick',
				'name'  => __( 'Arrow Left Thick', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-arrow-down-thick',
				'name'  => __( 'Arrow Down Thick', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-arrow-right-thick',
				'name'  => __( 'Arrow Right Thick', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-arrow-up-thick',
				'name'  => __( 'Arrow Up Thick', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-arrow-back',
				'name'  => __( 'Arrow Back', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-arrow-forward',
				'name'  => __( 'Arrow Forward', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-triangle-left',
				'name'  => __( 'Triangle Left', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-triangle-right-fill',
				'name'  => __( 'Triangle Right Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-triangle-right',
				'name'  => __( 'Triangle Right', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-triangle-up-fill',
				'name'  => __( 'Triangle Up Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-triangle-up',
				'name'  => __( 'Triangle Up', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-triangle-down-fill',
				'name'  => __( 'Triangle Down Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-triangle-down',
				'name'  => __( 'Triangle Down', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-triangle-right',
				'name'  => __( 'Circle Triangle Right', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-triangle-left-fill',
				'name'  => __( 'Circle Triangle Left Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-triangle-left',
				'name'  => __( 'Circle Triangle Left', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-triangle-up',
				'name'  => __( 'Circle Triangle Up', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-triangle-down',
				'name'  => __( 'Circle Triangle Down', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-chevron-left-small',
				'name'  => __( 'Circle Chevron Left Small', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-chevron-left',
				'name'  => __( 'Circle Chevron Left', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-chevron-right',
				'name'  => __( 'Circle Chevron Right', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-chevron-up',
				'name'  => __( 'Circle Chevron Up', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-chevron-down',
				'name'  => __( 'Circle Chevron Down', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-triangle-right-fill',
				'name'  => __( 'Circle Triangle Right Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-triangle-left-fill',
				'name'  => __( 'Circle Triangle Left Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-triangle-up-fill',
				'name'  => __( 'Circle Triangle Up Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-triangle-down-fill',
				'name'  => __( 'Circle Triangle Down Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-chevron-left-fill',
				'name'  => __( 'Circle Chevron Left Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-chevron-right-fill',
				'name'  => __( 'Circle Chevron Right Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-chevron-up-fill',
				'name'  => __( 'Circle Chevron Up Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-chevron-down-fill',
				'name'  => __( 'Circle Chevron Down Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-chevron-horizontal',
				'name'  => __( 'Chevron Horizontal', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-chevron-vertical',
				'name'  => __( 'Chevron Vertical', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-arrow-up-down',
				'name'  => __( 'Arrow Up Down', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-arrow-right-left',
				'name'  => __( 'Arrow Right Left', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-arrow-shuffle',
				'name'  => __( 'Arrow Shuffle', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-arrow-repeat',
				'name'  => __( 'Arrow Repeat', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-fork-right',
				'name'  => __( 'Fork Right', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-fork-left',
				'name'  => __( 'Fork Left', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-plus',
				'name'  => __( 'Plus', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-minus',
				'name'  => __( 'Minus', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-cross',
				'name'  => __( 'Cross', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-check',
				'name'  => __( 'Check', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-question',
				'name'  => __( 'Question', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-alert',
				'name'  => __( 'Circle Alert', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-x',
				'name'  => __( 'Circle X', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-check',
				'name'  => __( 'Circle Check', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-plus',
				'name'  => __( 'Circle Plus', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-minus',
				'name'  => __( 'Circle Minus', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-triangle-alert',
				'name'  => __( 'Triangle Alert', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-stop',
				'name'  => __( 'Stop', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-info',
				'name'  => __( 'Info', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-play',
				'name'  => __( 'Play', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-pause',
				'name'  => __( 'Pause', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-command',
				'name'  => __( 'Command', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-sound-down',
				'name'  => __( 'Sound Down', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-sound-on',
				'name'  => __( 'Sound On', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-sound-off',
				'name'  => __( 'Sound Off', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-sound-up',
				'name'  => __( 'Sound Up', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-infinite',
				'name'  => __( 'Infinite', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-airplay-audio',
				'name'  => __( 'Airplay Audio', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-airplay-video',
				'name'  => __( 'Airplay Video', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-miniplayer',
				'name'  => __( 'Miniplayer', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-text-align-left',
				'name'  => __( 'Text Align Left', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-text-align-center',
				'name'  => __( 'Text Align Center', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-text-align-right',
				'name'  => __( 'Text Align Right', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-threads-fill',
				'name'  => __( 'Threads Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-text-align-justified',
				'name'  => __( 'Text Align Justified', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-mention',
				'name'  => __( 'Mention', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-heart',
				'name'  => __( 'Heart', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-full-screen',
				'name'  => __( 'Full Screen', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-normal-screen',
				'name'  => __( 'Normal Screen', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-align-left',
				'name'  => __( 'Align Left', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-align-horizontal-center',
				'name'  => __( 'Align Horizontal Center', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-align-right',
				'name'  => __( 'Align Right', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-align-top',
				'name'  => __( 'Align Top', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-align-vertical-center',
				'name'  => __( 'Align Vertical Center', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-align-bottom',
				'name'  => __( 'Align Bottom', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-share-box',
				'name'  => __( 'Share Box', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-download',
				'name'  => __( 'Download', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-align-to-top',
				'name'  => __( 'Align To Top', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-align-to-middle',
				'name'  => __( 'Align To Middle', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-align-to-bottom',
				'name'  => __( 'Align To Bottom', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-block',
				'name'  => __( 'Block', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-more-horizontal-fill',
				'name'  => __( 'More Horizontal Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-more-vertical-fill',
				'name'  => __( 'More Vertical Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-wifi',
				'name'  => __( 'Wifi', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-bluetooth',
				'name'  => __( 'Bluetooth', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-location',
				'name'  => __( 'Location', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-link-chain',
				'name'  => __( 'Link Chain', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-link-out',
				'name'  => __( 'Link Out', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-sign-out',
				'name'  => __( 'Sign Out', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-hashtag',
				'name'  => __( 'Hashtag', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-grid',
				'name'  => __( 'Grid', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-link-on',
				'name'  => __( 'Link On', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-link-off',
				'name'  => __( 'Link Off', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-chat-bubble',
				'name'  => __( 'Chat Bubble', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-chat-add',
				'name'  => __( 'Chat Add', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-chat-remove',
				'name'  => __( 'Chat Remove', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-zoom-in',
				'name'  => __( 'Zoom In', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-zoom-out',
				'name'  => __( 'Zoom Out', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-box',
				'name'  => __( 'Box', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-check-box',
				'name'  => __( 'Check Box', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-check-box-fill',
				'name'  => __( 'Check Box Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-rss',
				'name'  => __( 'Rss', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-backspace',
				'name'  => __( 'Backspace', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-backspace-fill',
				'name'  => __( 'Backspace Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-double-check',
				'name'  => __( 'Double Check', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-drag-vertical-fill',
				'name'  => __( 'Drag Vertical Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-drag-horizontal-fill',
				'name'  => __( 'Drag Horizontal Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-dot-grid-fill',
				'name'  => __( 'Dot Grid Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-chat-dots',
				'name'  => __( 'Chat Dots', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-chat-error',
				'name'  => __( 'Chat Error', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-health',
				'name'  => __( 'Health', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-question-fill',
				'name'  => __( 'Question Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-alert-fill',
				'name'  => __( 'Circle Alert Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-x-fill',
				'name'  => __( 'Circle X Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-plus-fill',
				'name'  => __( 'Circle Plus Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-minus-fill',
				'name'  => __( 'Circle Minus Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-circle-check-fill',
				'name'  => __( 'Circle Check Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-triangle-alert-fill',
				'name'  => __( 'Triangle Alert Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-stop-fill',
				'name'  => __( 'Stop Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-info-fill',
				'name'  => __( 'Info Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-cloud-download',
				'name'  => __( 'Cloud Download', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-cloud-upload',
				'name'  => __( 'Cloud Upload', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-network',
				'name'  => __( 'Network', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-toggle-off',
				'name'  => __( 'Toggle Off', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-toggle-on',
				'name'  => __( 'Toggle On', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-toggle-off-fill',
				'name'  => __( 'Toggle Off Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-toggle-on-fill',
				'name'  => __( 'Toggle On Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-three-line-horizontal',
				'name'  => __( 'Three Line Horizontal', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-three-line-vertical',
				'name'  => __( 'Three Line Vertical', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-two-line-horizontal',
				'name'  => __( 'Two Line Horizontal', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-two-line-vertical',
				'name'  => __( 'Two Line Vertical', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-pointer-left-fill',
				'name'  => __( 'Pointer Left Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-pointer-right-fill',
				'name'  => __( 'Pointer Right Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-pointer-up-fill',
				'name'  => __( 'Pointer Up Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-pointer-down-fill',
				'name'  => __( 'Pointer Down Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-chat-approve',
				'name'  => __( 'Chat Approve', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-chat-question',
				'name'  => __( 'Chat Question', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-chat-edit',
				'name'  => __( 'Chat Edit', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-cursor',
				'name'  => __( 'Cursor', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-frame',
				'name'  => __( 'Frame', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-slice',
				'name'  => __( 'Slice', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-percentage',
				'name'  => __( 'Percentage', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-check-in',
				'name'  => __( 'Check In', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-video',
				'name'  => __( 'Video', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-cut',
				'name'  => __( 'Cut', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-filter',
				'name'  => __( 'Filter', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-settings-horizontal',
				'name'  => __( 'Settings Horizontal', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-settings-vertical',
				'name'  => __( 'Settings Vertical', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-ascending',
				'name'  => __( 'Ascending', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-descending',
				'name'  => __( 'Descending', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-statistic-up',
				'name'  => __( 'Statistic Up', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-statistic-down',
				'name'  => __( 'Statistic Down', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-panel-right',
				'name'  => __( 'Panel Right', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-panel-left',
				'name'  => __( 'Panel Left', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-panel-split',
				'name'  => __( 'Panel Split', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-dashboard',
				'name'  => __( 'Dashboard', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-panel-bottom',
				'name'  => __( 'Panel Bottom', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-panel-top',
				'name'  => __( 'Panel Top', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-panel-split-row',
				'name'  => __( 'Panel Split Row', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-panel-split-column',
				'name'  => __( 'Panel Split Column', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-language',
				'name'  => __( 'Language', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-sort',
				'name'  => __( 'Sort', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-equal',
				'name'  => __( 'Equal', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-equal-fill',
				'name'  => __( 'Equal Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-radio',
				'name'  => __( 'Radio', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-radio-fill',
				'name'  => __( 'Radio Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-save',
				'name'  => __( 'Save', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-augmented-reality',
				'name'  => __( 'Augmented Reality', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-ribbon',
				'name'  => __( 'Ribbon', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-phone',
				'name'  => __( 'Phone', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-attach',
				'name'  => __( 'Attach', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-thunder',
				'name'  => __( 'Thunder', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-send',
				'name'  => __( 'Send', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-sun',
				'name'  => __( 'Sun', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-moon',
				'name'  => __( 'Moon', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-pencil',
				'name'  => __( 'Pencil', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-pin',
				'name'  => __( 'Pin', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-draft',
				'name'  => __( 'Draft', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-eye-open',
				'name'  => __( 'Eye Open', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-eye-slashed',
				'name'  => __( 'Eye Slashed', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-eye-closed',
				'name'  => __( 'Eye Closed', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-airpods',
				'name'  => __( 'Airpods', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-paper',
				'name'  => __( 'Paper', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-file',
				'name'  => __( 'File', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-headphone',
				'name'  => __( 'Headphone', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-mobile-device',
				'name'  => __( 'Mobile Device', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-tablet-device',
				'name'  => __( 'Tablet Device', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-laptop-device',
				'name'  => __( 'Laptop Device', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-desktop-device',
				'name'  => __( 'Desktop Device', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-watch-device',
				'name'  => __( 'Watch Device', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-wallet',
				'name'  => __( 'Wallet', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-search',
				'name'  => __( 'Search', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-lock-on',
				'name'  => __( 'Lock On', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-lock-off',
				'name'  => __( 'Lock Off', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-camera',
				'name'  => __( 'Camera', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-image',
				'name'  => __( 'Image', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-folder',
				'name'  => __( 'Folder', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-folder-add',
				'name'  => __( 'Folder Add', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-calendar',
				'name'  => __( 'Calendar', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-bell',
				'name'  => __( 'Bell', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-battery-empty',
				'name'  => __( 'Battery Empty', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-battery-low',
				'name'  => __( 'Battery Low', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-battery-medium',
				'name'  => __( 'Battery Medium', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-battery-full',
				'name'  => __( 'Battery Full', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-flashlight',
				'name'  => __( 'Flashlight', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-calculator',
				'name'  => __( 'Calculator', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-alarm',
				'name'  => __( 'Alarm', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-globe',
				'name'  => __( 'Globe', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-book-open',
				'name'  => __( 'Book Open', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-cloud',
				'name'  => __( 'Cloud', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-envelope',
				'name'  => __( 'Envelope', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-shopping-bag',
				'name'  => __( 'Shopping Bag', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-gift',
				'name'  => __( 'Gift', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-map',
				'name'  => __( 'Map', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-shield',
				'name'  => __( 'Shield', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-tag',
				'name'  => __( 'Tag', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-gear',
				'name'  => __( 'Gear', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-flag',
				'name'  => __( 'Flag', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-ticket',
				'name'  => __( 'Ticket', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-bug',
				'name'  => __( 'Bug', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-copy',
				'name'  => __( 'Copy', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-lifesaver',
				'name'  => __( 'Lifesaver', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-star',
				'name'  => __( 'Star', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-battery-charging',
				'name'  => __( 'Battery Charging', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-trophy',
				'name'  => __( 'Trophy', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-leaf',
				'name'  => __( 'Leaf', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-schedule',
				'name'  => __( 'Schedule', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-money',
				'name'  => __( 'Money', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-scissor',
				'name'  => __( 'Scissor', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-coin',
				'name'  => __( 'Coin', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-telescope',
				'name'  => __( 'Telescope', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-planet',
				'name'  => __( 'Planet', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-game-controller',
				'name'  => __( 'Game Controller', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-vr-ar',
				'name'  => __( 'Vr Ar', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-computing',
				'name'  => __( 'Computing', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-inbox',
				'name'  => __( 'Inbox', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-light-bulb',
				'name'  => __( 'Light Bulb', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-chess',
				'name'  => __( 'Chess', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-trash-can',
				'name'  => __( 'Trash Can', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-microphone',
				'name'  => __( 'Microphone', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-coffee',
				'name'  => __( 'Coffee', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-credit-card',
				'name'  => __( 'Credit Card', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-utensils',
				'name'  => __( 'Utensils', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-radish',
				'name'  => __( 'Radish', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-clipboard',
				'name'  => __( 'Clipboard', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-bicycle',
				'name'  => __( 'Bicycle', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-plane',
				'name'  => __( 'Plane', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-plane-fill',
				'name'  => __( 'Plane Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-jar',
				'name'  => __( 'Jar', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-glasses',
				'name'  => __( 'Glasses', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-plant',
				'name'  => __( 'Plant', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-edit',
				'name'  => __( 'Edit', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-trash-bin',
				'name'  => __( 'Trash Bin', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-sun-fill',
				'name'  => __( 'Sun Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-moon-fill',
				'name'  => __( 'Moon Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-key-cap',
				'name'  => __( 'Key Cap', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-newspaper',
				'name'  => __( 'Newspaper', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-door',
				'name'  => __( 'Door', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-water',
				'name'  => __( 'Water', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-fire',
				'name'  => __( 'Fire', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-air',
				'name'  => __( 'Air', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-home',
				'name'  => __( 'Home', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-umbrella',
				'name'  => __( 'Umbrella', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-togo-cup',
				'name'  => __( 'Togo Cup', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-devices',
				'name'  => __( 'Devices', 'logistics-hub' ),
			),
			array(
				'group' => 'ecommerce',
				'id'    => 'ai-shipping-box-v1',
				'name'  => __( 'Shipping Box V1', 'logistics-hub' ),
			),
			array(
				'group' => 'ecommerce',
				'id'    => 'ai-shipping-box-v2',
				'name'  => __( 'Shipping Box V2', 'logistics-hub' ),
			),
			array(
				'group' => 'ecommerce',
				'id'    => 'ai-cart',
				'name'  => __( 'Cart', 'logistics-hub' ),
			),
			array(
				'group' => 'ecommerce',
				'id'    => 'ai-basket',
				'name'  => __( 'Basket', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-open-envelope',
				'name'  => __( 'Open Envelope', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-clock',
				'name'  => __( 'Clock', 'logistics-hub' ),
			),
			array(
				'group' => 'ecommerce',
				'id'    => 'ai-truck',
				'name'  => __( 'Truck', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-wine-glass',
				'name'  => __( 'Wine Glass', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-x-fill',
				'name'  => __( 'X Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-x-small',
				'name'  => __( 'X Small', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-vape-kit',
				'name'  => __( 'Vape Kit', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-briefcase',
				'name'  => __( 'Briefcase', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-boat',
				'name'  => __( 'Boat', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-crown',
				'name'  => __( 'Crown', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-sword',
				'name'  => __( 'Sword', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-double-sword',
				'name'  => __( 'Double Sword', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-key',
				'name'  => __( 'Key', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-dental',
				'name'  => __( 'Dental', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-cake',
				'name'  => __( 'Cake', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-book-close',
				'name'  => __( 'Book Close', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-sparkles',
				'name'  => __( 'Sparkles', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-music',
				'name'  => __( 'Music', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-music-note',
				'name'  => __( 'Music Note', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-music-album',
				'name'  => __( 'Music Album', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-music-album-fill',
				'name'  => __( 'Music Album Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-bank',
				'name'  => __( 'Bank', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-paper-airplane',
				'name'  => __( 'Paper Airplane', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-home-alt1',
				'name'  => __( 'Home Alt1', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-credit-card-alt1',
				'name'  => __( 'Credit Card Alt1', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-receipt',
				'name'  => __( 'Receipt', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-hammer',
				'name'  => __( 'Hammer', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-data',
				'name'  => __( 'Data', 'logistics-hub' ),
			),

			array(
				'group' => 'general',
				'id'    => 'ai-dice-6',
				'name'  => __( 'Dice6', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-dice-5',
				'name'  => __( 'Dice5', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-dice-4',
				'name'  => __( 'Dice 4', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-dice-3',
				'name'  => __( 'Dice 3', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-dice-2',
				'name'  => __( 'Dice 2', 'logistics-hub' ),
			),
			array(
				'group' => 'general',
				'id'    => 'ai-dice-1',
				'name'  => __( 'Dice 1', 'logistics-hub' ),
			),
			array(
				'group' => 'person',
				'id'    => 'ai-person',
				'name'  => __( 'Person', 'logistics-hub' ),
			),
			array(
				'group' => 'person',
				'id'    => 'ai-person-add',
				'name'  => __( 'Person Add', 'logistics-hub' ),
			),
			array(
				'group' => 'person',
				'id'    => 'ai-person-check',
				'name'  => __( 'Person Check', 'logistics-hub' ),
			),
			array(
				'group' => 'person',
				'id'    => 'ai-person-cross',
				'name'  => __( 'Person Cross', 'logistics-hub' ),
			),
			array(
				'group' => 'person',
				'id'    => 'ai-face-very-happy',
				'name'  => __( 'Face Very Happy', 'logistics-hub' ),
			),
			array(
				'group' => 'person',
				'id'    => 'ai-face-happy',
				'name'  => __( 'Face Happy', 'logistics-hub' ),
			),
			array(
				'group' => 'person',
				'id'    => 'ai-face-neutral',
				'name'  => __( 'Face Neutral', 'logistics-hub' ),
			),
			array(
				'group' => 'person',
				'id'    => 'ai-face-sad',
				'name'  => __( 'Face Sad', 'logistics-hub' ),
			),
			array(
				'group' => 'person',
				'id'    => 'ai-face-very-sad',
				'name'  => __( 'Face Very Sad', 'logistics-hub' ),
			),
			array(
				'group' => 'person',
				'id'    => 'ai-face-wink',
				'name'  => __( 'Face Wink', 'logistics-hub' ),
			),
			array(
				'group' => 'person',
				'id'    => 'ai-thumbs-up',
				'name'  => __( 'Thumbs Up', 'logistics-hub' ),
			),
			array(
				'group' => 'person',
				'id'    => 'ai-thumbs-down',
				'name'  => __( 'Thumbs Down', 'logistics-hub' ),
			),
			array(
				'group' => 'person',
				'id'    => 'ai-victory-hand',
				'name'  => __( 'Victory Hand', 'logistics-hub' ),
			),
			array(
				'group' => 'person',
				'id'    => 'ai-pointing-up',
				'name'  => __( 'Pointing Up', 'logistics-hub' ),
			),
			array(
				'group' => 'person',
				'id'    => 'ai-rock-on',
				'name'  => __( 'Rock On', 'logistics-hub' ),
			),
			array(
				'group' => 'person',
				'id'    => 'ai-people-multiple',
				'name'  => __( 'People Multiple', 'logistics-hub' ),
			),
			array(
				'group' => 'person',
				'id'    => 'ai-people-group',
				'name'  => __( 'People Group', 'logistics-hub' ),
			),
			array(
				'group' => 'person',
				'id'    => 'ai-hand',
				'name'  => __( 'Hand', 'logistics-hub' ),
			),
			array(
				'group' => 'person',
				'id'    => 'ai-pointer-hand',
				'name'  => __( 'Pointer Hand', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-facebook-fill',
				'name'  => __( 'Facebook Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-twitter-fill',
				'name'  => __( 'Twitter Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-linkedin-box-fill',
				'name'  => __( 'Linkedin Box Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-dribbble-fill',
				'name'  => __( 'Dribbble Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-reddit-fill',
				'name'  => __( 'Reddit Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-tumblr-fill',
				'name'  => __( 'Tumblr Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-pinterest-fill',
				'name'  => __( 'Pinterest Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-vk-fill',
				'name'  => __( 'Vk Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-youtube-fill',
				'name'  => __( 'Youtube Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-instagram-fill',
				'name'  => __( 'Instagram Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-figma-fill',
				'name'  => __( 'Figma Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-github-fill',
				'name'  => __( 'Github Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-telegram-fill',
				'name'  => __( 'Telegram Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-dropbox-fill',
				'name'  => __( 'Dropbox Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-google-fill',
				'name'  => __( 'Google Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-google-contained-fill',
				'name'  => __( 'Google Contained Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-android-fill',
				'name'  => __( 'Android Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-bitcoin-fill',
				'name'  => __( 'Bitcoin Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-spotify-fill',
				'name'  => __( 'Spotify Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-soundcloud-fill',
				'name'  => __( 'Soundcloud Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-codepen-fill',
				'name'  => __( 'Codepen Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-whatsapp-fill',
				'name'  => __( 'Whatsapp Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-linkedin-fill',
				'name'  => __( 'Linkedin Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-vimeo-fill',
				'name'  => __( 'Vimeo Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-medium-fill',
				'name'  => __( 'Medium Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-zoom-fill',
				'name'  => __( 'Zoom Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-slack-fill',
				'name'  => __( 'Slack Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-stack-overflow-fill',
				'name'  => __( 'Stack Overflow Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-twitch-fill',
				'name'  => __( 'Twitch Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-snapchat-fill',
				'name'  => __( 'Snapchat Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-octocat-fill',
				'name'  => __( 'Octocat Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-discord-fill',
				'name'  => __( 'Discord Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-behance-fill',
				'name'  => __( 'Behance Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-postgresql-fill',
				'name'  => __( 'Postgresql Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-price-cut',
				'name'  => __( 'Price Cut', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-mastodon-fill',
				'name'  => __( 'Mastodon Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-tiktok-fill',
				'name'  => __( 'Tiktok Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-unsplash-fill',
				'name'  => __( 'Unsplash Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-product-hunt-fill',
				'name'  => __( 'Product Hunt Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'shapes',
				'id'    => 'ai-circle',
				'name'  => __( 'Circle', 'logistics-hub' ),
			),
			array(
				'group' => 'shapes',
				'id'    => 'ai-circle-fill',
				'name'  => __( 'Circle Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'shapes',
				'id'    => 'ai-triangle',
				'name'  => __( 'Triangle', 'logistics-hub' ),
			),
			array(
				'group' => 'shapes',
				'id'    => 'ai-triangle-fill',
				'name'  => __( 'Triangle Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'shapes',
				'id'    => 'ai-square',
				'name'  => __( 'Square', 'logistics-hub' ),
			),
			array(
				'group' => 'shapes',
				'id'    => 'ai-square-fill',
				'name'  => __( 'Square Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'shapes',
				'id'    => 'ai-tetragon',
				'name'  => __( 'Tetragon', 'logistics-hub' ),
			),
			array(
				'group' => 'shapes',
				'id'    => 'ai-tetragon-fill',
				'name'  => __( 'Tetragon Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'shapes',
				'id'    => 'ai-pentagon',
				'name'  => __( 'Pentagon', 'logistics-hub' ),
			),
			array(
				'group' => 'shapes',
				'id'    => 'ai-pentagon-fill',
				'name'  => __( 'Pentagon Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'shapes',
				'id'    => 'ai-hexagon',
				'name'  => __( 'Hexagon', 'logistics-hub' ),
			),
			array(
				'group' => 'shapes',
				'id'    => 'ai-history',
				'name'  => __( 'History', 'logistics-hub' ),
			),
			array(
				'group' => 'shapes',
				'id'    => 'ai-hexagon-fill',
				'name'  => __( 'Hexagon Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'shapes',
				'id'    => 'ai-heptagon',
				'name'  => __( 'Heptagon', 'logistics-hub' ),
			),
			array(
				'group' => 'shapes',
				'id'    => 'ai-heptagon-fill',
				'name'  => __( 'Heptagon Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'shapes',
				'id'    => 'ai-octagon',
				'name'  => __( 'Octagon', 'logistics-hub' ),
			),
			array(
				'group' => 'shapes',
				'id'    => 'ai-octagon-fill',
				'name'  => __( 'Octagon Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'shapes',
				'id'    => 'ai-oval',
				'name'  => __( 'Oval', 'logistics-hub' ),
			),
			array(
				'group' => 'shapes',
				'id'    => 'ai-parallelogram',
				'name'  => __( 'Parallelogram', 'logistics-hub' ),
			),
			array(
				'group' => 'shapes',
				'id'    => 'ai-diamond',
				'name'  => __( 'Diamond', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-bootstrap-fill',
				'name'  => __( 'Bootstrap Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-react-fill',
				'name'  => __( 'React Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-angular-fill',
				'name'  => __( 'Angular Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-vue-fill',
				'name'  => __( 'Vue Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-javascript-fill',
				'name'  => __( 'Javascript Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-node-fill',
				'name'  => __( 'Node Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-html-fill',
				'name'  => __( 'Html Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-css-fill',
				'name'  => __( 'Css Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-vercel-fill',
				'name'  => __( 'Vercel Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-nextjs-fill',
				'name'  => __( 'Nextjs Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-redux-fill',
				'name'  => __( 'Redux Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-python-fill',
				'name'  => __( 'Python Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-graphql-fill',
				'name'  => __( 'Graphql Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-php-fill',
				'name'  => __( 'Php Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-jquery-fill',
				'name'  => __( 'Jquery Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-sass-fill',
				'name'  => __( 'Sass Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-gatsby-fill',
				'name'  => __( 'Gatsby Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-npm-fill',
				'name'  => __( 'Npm Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-yarn-fill',
				'name'  => __( 'Yarn Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-yelp-fill',
				'name'  => __( 'Yelp Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-django-fill',
				'name'  => __( 'Django Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-vscode-fill',
				'name'  => __( 'Vscode Fill', 'logistics-hub' ),
			),
			array(
				'group' => 'social',
				'id'    => 'ai-typescript-fill',
				'name'  => __( 'Typescript Fill', 'logistics-hub' ),
			),
		);

		/**
		 * Filter genericon items
		 *
		 * @since 0.1.0
		 * @param array $items Icon names.
		 */
		$items = apply_filters( 'icon_picker_akar_items', $items );

		return $items;
	}
}
